﻿var dbServers = {
    context: $(".v-databaseServers"),
    datatable: null,
    refreshDataTable: function () {
        dbServers.datatable.a4datatable("refresh");
    },
    highestSrvNo : 1,
    initializeDataTable: function () {
        this.datatable = $(".v-databaseServersTable", dbServers.context).a4datatable({
            title: resources.DatabasesServers,
            ajaxAction: a4.getAction("GetDatabaseServers", "System", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id },
                { "Name": "Name", "Title": resources.Name },
                { "Name": "SrvNo", "Title": resources.ServerNo },
                { "Name": "SystemDatabaseName", "Title": resources.SystemDatabaseName },
                { "Name": "NamedInstance", "Title": resources.NamedInstance }
            ],
            contextMenuItems: [
                { "Action": "properties", "Label": resources.Properties },
                { "Action" : "testConnection", "Label" : resources.TestConnection },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.SrvNo > 1; } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "properties") {
                    dbServers.showServerProperties(row.Id);
                }
                else if (action == "testConnection") {
                    dbServers.testConnection(row.Id);
                }
                else if (action == "delete") {
                    dbServers.deleteServer(row.Id);
                }
            },
            rowBeforeCreated: function (event, data) {
                var data = data.data;
                if (data["SrvNo"] > dbServers.highestSrvNo)
                    dbServers.highestSrvNo = data["SrvNo"];
            }
        });
    },
    bindEvents: function () {
        $(".h-newDatabaseServerMenu").on("click", "li.h-newDatabaseServer", function () {
            modalDialog.showWindow(a4.getAction("EditDatabaseServer", "System", "Settings", { lastSrvNo: dbServers.highestSrvNo }), 500, 700, { afterClose: function () { dbServers.refreshDataTable(); } });
        });
    },
    showServerProperties: function (serverId) {
        modalDialog.showWindow(a4.getAction("EditDatabaseServer", "System", "Settings", { id: serverId }), 500, 700, { afterClose: function () { dbServers.refreshDataTable(); } });
    },
    deleteServer: function (serverId) {
        modalDialog.showConfirmDialog(confirmDeleteServerResources, function () {
            a4.callServerMethod(a4.getAction("DeleteDatabaseServer", "System", "Settings"), { id: serverId }, function (result) {
                if (result.success)
                    dbServers.refreshDataTable();
                else
                    a4.showErrorMessage(result.message);
            });
        }, 200, 550, true);
    },
    testConnection: function (serverId) {
        a4.callServerMethod(a4.getAction("TestDatabaseConnection", "System", "Settings"), { id: serverId }, function (result) {
            if (result.success)
                a4.showSuccessMessage(resources.Success);
            else
                a4.showErrorMessage(resources.Failed);
        });
    }
}

$(document).ready(function () {
    if (dbServers.context.length > 0) {
        dbServers.initializeDataTable();
        dbServers.bindEvents();
    }
});


